package gov.va.med.mhv.admin.web.controller;

import gov.va.med.mhv.admin.dto.EmployeeDTO;
import gov.va.med.mhv.admin.dto.EmployeeOrgRoleDTO;
import gov.va.med.mhv.admin.dto.EmployeeSearchResult;
import gov.va.med.mhv.admin.service.vastaff.EmployeeRoleManagementService;
import gov.va.med.mhv.admin.service.vastaff.EmployeeSearchService;
import gov.va.med.mhv.admin.web.formbean.SearchResultsFormBean;
import gov.va.med.mhv.admin.web.formbean.StaffSearchFormBean;
import gov.va.med.mhv.admin.web.util.SessionUtil;
import gov.va.med.mhv.admin.web.util.SpringContext;
import gov.va.med.mhv.common.api.exception.MHVException;

import java.util.List;
import java.util.Map;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;

@ManagedBean(name="searchController")
@RequestScoped
public class SearchStaffController {
	
	private static Logger log = LogManager.getLogger(SearchStaffController.class);
	
	@ManagedProperty(value="#{search}")
	StaffSearchFormBean searchForm;
	
	@ManagedProperty(value="#{staffSearchResults}")
	SearchResultsFormBean searchResults;
	
	
	/**
	 * Invoked when a user clicks the "Search" button on the search form UI.
	 * 
	 * @return the view to advance to, whether search results or back to search form.
	 */
	public String search() {
		String result = "";
		searchResults.setCameFrom(SearchResultsFormBean.CameFrom.SEARCH);
		String id = searchForm.getVaNetworkId();
		try {
			System.out.println(1); //adminUserServiceProxy
			EmployeeSearchService employeeSearchService = (EmployeeSearchService) SpringContext.getApplicationContext().getBean("employeeSearchServiceProxy");
			System.out.println(2);
			List<EmployeeSearchResult> employees = null;
			if (id == null || "".equals(id.trim())) {
				// search by name
				System.out.println(3);
				String firstName = searchForm.getFirstName();
				System.out.println(3.1 + firstName);
				String lastName = searchForm.getLastName();
				System.out.println(3.2 + lastName);
				employees = employeeSearchService.searchByName(firstName, lastName);
			}
			else {
				// search by va network id
				System.out.println(4);
				employees = employeeSearchService.searchByUserName(id);

			}
			System.out.println(5);
			if (employees != null) {
				// stick empoyee in flash for redirect to search results page
				searchResults.setEmployees(employees);
				for (EmployeeSearchResult emp : employees) {
					System.out.println("Emp: " + emp.getId());
					System.out.println("FN: " + emp.getFullName());
					System.out.println("FirstN: " + emp.getFirstName());
					System.out.println("LastN: " + emp.getLastName());
				}
				//FacesContext.getCurrentInstance().getExternalContext().getFlash().put("employee", employees);
				
				System.out.println(6);
				result = "search-staff-results?faces-redirect=true";
			}
			else {
				System.out.println(9);
				// stay on search criteria page
				FacesContext.getCurrentInstance().addMessage("No search results.", new FacesMessage("Please check your search criteria and try again."));
			}
			
		} catch (MHVException e) {
			System.out.println(10);
			log.error("Error in SearchStaffController.search() - Searching Proxy 'employeeSearchServiceProxy'", e);
			FacesContext.getCurrentInstance().addMessage("Error Occurred", new FacesMessage("An error occurred performing Staff Search, please retry."));
		} catch (Exception e) {
			System.out.println(11);
			log.error("General error in SearchStaffController.search() - Searching Proxy 'employeeSearchServiceProxy'", e);
			FacesContext.getCurrentInstance().addMessage("Error Occurred", new FacesMessage("A general error occurred performing Staff Search, please retry."));
		}
		System.out.println(11);
		return result;
	}
	
	public String viewAll() {
		String result = "";
		searchResults.setCameFrom(SearchResultsFormBean.CameFrom.VIEW_ALL);
		System.out.println("View All!");
		try {
			EmployeeRoleManagementService service = (EmployeeRoleManagementService) SpringContext.getApplicationContext().getBean("employeeRoleManagementServiceProxy");
			EmployeeDTO loggedInEmployee = new SessionUtil().getCurrentUser();
			List<EmployeeOrgRoleDTO> assignedRoles = service.getEmployeeOrganizationRolesEmployeeCanManage(loggedInEmployee.getEmployeeId());
			searchResults.setRoles(assignedRoles);
			result = "view-all";
		} catch (BeansException e) {
			log.error("Error in employeeRoleManagementServiceProxy.getEmployeeOrgRolesAssignedToEmployeeByName() - Searching Proxy 'employeeRoleManagementServiceProxy'", e);
			FacesContext.getCurrentInstance().addMessage("Error Occurred", new FacesMessage("An error occurred retrieving the assigned Employee Organizational Roles, please retry."));
		} catch (MHVException e) {
			log.error("Error in employeeRoleManagementServiceProxy.getEmployeeOrgRolesAssignedToEmployeeByName() - Searching Proxy 'employeeRoleManagementServiceProxy'", e);
			FacesContext.getCurrentInstance().addMessage("Error Occurred", new FacesMessage("An error occurred retrieving the assigned Employee Organizational Roles, please retry."));
		} catch (RuntimeException e) {
			log.error("Unexpected Error in employeeRoleManagementServiceProxy.getEmployeeOrgRolesAssignedToEmployeeByName() - Searching Proxy 'employeeRoleManagementServiceProxy'", e);
			FacesContext.getCurrentInstance().addMessage("Unexpected Error Occurred", new FacesMessage("An error occurred retrieving the assigned Employee Organizational Roles, please retry."));
		}
		return result;
	}
	
	public String newSearch() {
		System.out.println("Called SearchStaffController.newSearch()");
		return "search-staff";
	}
	
	public StaffSearchFormBean getSearchForm() {
		return searchForm;
	}

	public void setSearchForm(StaffSearchFormBean searchForm) {
		this.searchForm = searchForm;
	}

	public SearchResultsFormBean getSearchResults() {
		return searchResults;
	}

	public void setSearchResults(SearchResultsFormBean searchResults) {
		this.searchResults = searchResults;
	}
	
	public String backToSearchResults() {
		String result = "";
		if (searchResults.getCameFrom() == SearchResultsFormBean.CameFrom.VIEW_ALL) {
			result = "view-all-current-roles?faces-redirect=true";
		}
		else {
			result = "search-staff-results?faces-redirect=true";
		}
		System.out.println(result);
		return result;
	}
	
}
